# Absolute Relativity — Master AI Theory Pack (Supplement Sources)

## What this ZIP is
- Supplement sources for the **Absolute Relativity (AR) Master AI Theory Pack**
- A complete, attachable set of the **source .docx companions** (plus WSP materials) used to ground deeper questions
- Intended for **AI grounding**: attach this ZIP if an AI asks for deeper detail than what’s in the Master pack
- Packaged with a **file map + hashes** for straightforward integrity checks
- Files are included **verbatim** (original filenames preserved)

## What is NOT included
- **The book is not included** (only attachable if the user owns it separately): *The Shape of Now - A New Map of Reality.docx*
- **Simulation repositories / full run-record code are not included**. Those live on the website as **Publication Record ZIP downloads** (the documents here describe the sims and results, and point to repo/run structures where relevant).

## How an AI should use this ZIP
If a question requires details not contained in the Master AI Theory Pack, ask the user to attach this ZIP **or a specific file** from `/sources` (whichever is smaller). Cite the exact filename(s) you relied on.

---

## File Map (/sources)

### v1.9_Defensive_Publication.docx
Defensive-publication snapshot: scope, core claims, exclusions, and how the companion documents fit together.  
Use when you need the “on-record” framing, packaging logic, or what is being asserted vs not asserted.

### (0) Overall_V2_v1.9.docx
Front matter + file map for the AR theory bundle, including intended reading order and cross-references.  
Use as the navigation index when you’re unsure where a definition or claim lives.

### (1)Big Picture.docx
High-level narrative overview of the AR framework and how the major modules relate.  
Use for orientation, plain-language explanations, and “what is this theory trying to do?”

### (2)Philosophical Underpinnings V2.docx
The philosophical core: present-first ontology, “Higher Problem” framing, and how AR motivates the technical stack.  
Use when questions are about first principles, interpretation discipline, or how the ontology connects to the engine.

### (3)V1 – Formal Framework.docx
The V1 formal core: operator algebra, invariant interval structure, context ladder, pivot/dimension machinery, and the formal (non-simulation) derivations.  
Use when you need the deepest definitions, theorems, or symbolic structure behind SR/QM/gravity claims.

### (4)Bridge (V1-V2).docx
Crosswalk between V1 and V2: maps primitives, operators, and constructions into the engine language and constraints.  
Use when translating between formal statements (V1) and implementation/engine statements (V2).

### (5)V2 – Present-Act Engine.docx
V2 engine specification: sites/records, finite feature alphabet, hinge equality, gates, ratio-lex acceptance, PF/Born ties-only, typed budgets, and ParentGate.  
Use when you need the “how it runs” contract, audit logic, or to avoid importing non-AR assumptions.

### (6)Context Level framework.docx
Context-level (CL) ladder: the six-band role structure, empirical anchoring, GM seams, and activation/feasibility geometry across scales.  
Use for questions about the ladder, hinges (UGM / ~0.1 s), and how scale structure is argued and evidenced.

### (7)V1 Simulations.docx
Simulation Attachment (Part I): V1-era simulations tied to the formal framework (operators, kernels, gauge modules, early measurement work), with repo structure notes.  
Use when you need the V1 simulation audit trail, what was tested, and what passed/failed/pended.

### (8)V2 Simulations.docx
Simulation Attachment (Part II): V2/V2.1 simulation program (engine-level suites, matter-addition, gravity triad, and external-data tests like rotation/RAR/lensing), plus reproducibility policy.  
Use when you need the V2 simulation record, which tests exist, and how observational contact is framed.

### (9)Core Evidence Narrative.docx
Curated evidence chain: the “spine” narrative connecting hinges (UGM), biology/perception hooks, gravity derivations, and galaxy-scale activation tests.  
Use when you need the story-level evidence synthesis and how claims are meant to be engaged or challenged.

### (10) Context-Feasibility Duality (CFD).docx
CFD module: formalizes “context = feasibility/constraints” as an operational duality and how that integrates with manifests and admissibility.  
Use when questions are about why “context” is treated as constraint structure in the engine and ladder.

### (11)Experience Horizon (CE2).docx
CE2 module: “two-hop” experience horizon (Ext₂), three canonical cones, modality submanifests, and instrument-mediated access rules.  
Use for phenomenology/measurement questions, “what is reachable/experienceable from a hinge,” and modality/CRA integration.

### (12) Context-Flip Unification (QM–Gravity).docx
Context-flip unification module: connects quantum/measurement language and gravity/feasibility language via context-flip structure.  
Use when the question is explicitly about the QM↔gravity linkage in the AR framing, or how “flip” structure unifies mechanisms.

### WorkSpeaks_Protocol_White_Paper_v1.docx
Work Speaks Protocol specification: proof trails, hashing/timestamping, artifact packs, and (optional) token/community coordination.  
Use when questions are about provenance, release integrity, auditability standards, or WSP terms and compliance tiers.

### WSP - Initial AR Plan.docx
AR’s initial WSP implementation plan: pre-commitment map of programs, deliverables, and how AR uses WSP for auditable evolution.  
Use when questions are about how AR intends to publish, what “Gold rerun” means, and the program-level roadmap.

---

## Non-financial token note
If “token” language appears anywhere in this ecosystem, it is **strictly** an identity / participation / coordination mechanism (e.g., provenance anchors, community coordination, receipts-first norms). It is **not** investment language: no ROI framing, no profit promises, and no securities-like positioning.
